/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.spiget.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.skinsrestorer.shadow.spiget.ResourceInfo;
import net.skinsrestorer.shadow.spiget.download.DownloadCallback;

public class UpdateDownloader {
    public static final String RESOURCE_DOWNLOAD = "https://api.spiget.org/v2/resources/%s/download";

    public static Runnable downloadAsync(ResourceInfo info, File file, String userAgent, DownloadCallback callback) {
        return () -> {
            try {
                UpdateDownloader.download(info, file, userAgent);
                callback.finished();
            }
            catch (Exception e) {
                callback.error(e);
            }
        };
    }

    public static void download(ResourceInfo info, File file, String userAgent) {
        ReadableByteChannel channel;
        if (info.external) {
            throw new IllegalArgumentException("Cannot download external resource #" + info.id);
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(String.format(RESOURCE_DOWNLOAD, info.id)).openConnection();
            connection.setRequestProperty("User-Agent", userAgent);
            connection.setInstanceFollowRedirects(true);
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("Download returned status #" + connection.getResponseCode());
            }
            channel = Channels.newChannel(connection.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Download failed", e);
        }
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save file", e);
        }
    }
}

